unit CommonXML;

{
  Common constants and database references
  for generating XML from the movie-watchers database.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 1 October, 2000.
}

interface

uses
  SysUtils, Classes, DB, DBTables;

resourcestring
  { XML tags and formats }
  CinemaId        = 'cinema-id';
  CinemasTag      = 'cinemas';
  CinemaTag       = 'cinema';
  FacilitiesTag   = 'facilities';
  FeaturesTag     = 'features';
  Id              = 'id';
  MovieId         = 'movie-id';
  MoviesTag       = 'movies';
  MovieTag        = 'movie';
  MovieWatcherTag = 'movie-watcher';
  PriceTag        = 'prices';
  PricingId       = 'pricing-id';
  PricingTag      = 'pricing';
  Rating          = 'rating';
  RestrictionsTag = 'restrictions';
  ScreeningsTag   = 'screenings';
  ScreeningTag    = 'screening';
  SessionsTag     = 'sessions';
  SessionTag      = 'session';
  StarringTag     = 'starring';
  { Field names }
  AddressField    = 'address';
  AdultField      = 'adult';
  CandyBarField   = 'candy_bar';
  ChildField      = 'child';
  CinemaIdField   = 'cinema_id';
  DigSoundField   = 'digital_sound';
  DirectionsField = 'directions';
  DirectorField   = 'director';
  DisabledField   = 'disabled_access';
  DiscountField   = 'discount';
  EndDateField    = 'end_date';
  LengthField     = 'length_mins';
  LogoURLField    = 'logo_url';
  MovieIdField    = 'movie_id';
  NameField       = 'name';
  NoPassesField   = 'no_passes';
  PeriodField     = 'period';
  PhoneField      = 'phone';
  PricingIdField  = 'pricing_id';
  RatingField     = 'rating';
  StarField       = 'star';
  StartDateField  = 'start_date';
  SynopsisField   = 'synopsis';
  TimeField       = 'time';
  URLField        = 'url';
  { XML prolog }
  XMLDTDFile      = 'movie-watcher.dtd';
  XMLComment      = ' Sample XML document with data about movies'#13 +
                    'and when and where they are showing'#13 +
                    'Developed by Keith Wood, 28 May 1999 ';
  XMLPrologAttrs  = 'version="1.0" encoding="UTF-8"';
  XMLStyleAttrs   = 'type="text/xsl" href="movie-watcher.xsl"';
  XMLStyleTag     = 'xml:stylesheet';
  XMLTag          = 'xml';
  { Notations and entities }
  HTMLPubId       = '-//W3C//DTD HTML 4.0 Transitional//EN';
  HTMLSysId       = '';
  HTMLType        = 'HTML';
  JPEGPubId       = '';
  JPEGSysId       = 'iview.exe';
  JPEGType        = 'JPEG';

{ Convert field names to XML names }
function ModifyName(Name: string): string;

type
  TdatCommonXML = class(TDataModule)
    qryMovie: TQuery;
    qryScreening: TQuery;
    qryCinema: TQuery;
    dsrMovie: TDataSource;
    dsrCinema: TDataSource;
    dsrScreening: TDataSource;
    qryStars: TQuery;
    qryPricing: TQuery;
    qrySessions: TQuery;
    qryMovieMovie_id: TIntegerField;
    qryMovieName: TStringField;
    qryMovieRating: TStringField;
    qryMovieDirector: TStringField;
    qryMovieSynopsis: TMemoField;
    qryMovieURL: TStringField;
    qryMovieLogo_URL: TStringField;
    qryCinemaCinema_id: TIntegerField;
    qryCinemaName: TStringField;
    qryCinemaPhone: TStringField;
    qryCinemaAddress: TStringField;
    qryCinemaDirections: TMemoField;
    qryCinemaCandy_bar: TBooleanField;
    qryCinemaDisabled_access: TBooleanField;
    qryScreeningMovie_id: TIntegerField;
    qryScreeningCinema_id: TIntegerField;
    qryScreeningStart_date: TDateField;
    qryScreeningEnd_date: TDateField;
    qryScreeningDigital_sound: TStringField;
    qryScreeningNo_passes: TBooleanField;
    qryStarsStar_id: TIntegerField;
    qryStarsMovie_id: TIntegerField;
    qryStarsStar: TStringField;
    qryPricingPricing_id: TIntegerField;
    qryPricingCinema_id: TIntegerField;
    qryPricingName: TStringField;
    qryPricingPeriod: TStringField;
    qryPricingAdult: TFloatField;
    qryPricingChild: TFloatField;
    qryPricingDiscount: TFloatField;
    qrySessionsMovie_id: TIntegerField;
    qrySessionsCinema_id: TIntegerField;
    qrySessionsTime: TTimeField;
    qrySessionsPricing_id: TIntegerField;
    qryMovieLength_Mins: TIntegerField;
    procedure GetMemoText(Sender: TField; var Text: String;
      DisplayText: Boolean);
  private
  public
  end;

var
  datCommonXML: TdatCommonXML;

implementation

{$R *.dfm}

{$IFDEF VER100}  { Delphi 3 }
type
  TReplaceFlags = set of (rfReplaceAll, rfIgnoreCase);

function StringReplace(const Value, OldPattern, NewPattern: string;
  Flags: TReplaceFlags): string;
var
  Index: Integer;
begin
  Result := Value;
  Index  := Pos(OldPattern, Result);
  while (Index > 0) do
  begin
    Delete(Result, Index, Length(OldPattern));
    Insert(NewPattern, Result, Index);
    if not (rfReplaceAll in Flags) then
      Break;
    Index := Pos(OldPattern, Result);
  end;
end;
{$ENDIF}

{ Convert field names to XML names }
function ModifyName(Name: string): string;
begin
  Result := LowerCase(StringReplace(Name, '_', '-', [rfReplaceAll]));
end;

{ Supply memo as text }
procedure TdatCommonXML.GetMemoText(Sender: TField; var Text: String;
  DisplayText: Boolean);
begin
  Text := Sender.AsString;
end;

end.
